<?php

namespace Ipay\EmailClient;

use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;

class PhpMailerClient
{
    public $to;
    public $from;
    public $cc;
    public $subject;
    public $message;

    public function __construct()
    {
    }

    public function to($to='')
    {
        $this->to = $to;

        return $this;
    }

    public function from($from='')
    {
        $this->from = $from;

        return $this;
    }

    public function cc(array $cc = [])
    {
        if (empty($cc)){
            return null;
        }

        $emails = implode(" ", $cc);
        $this->cc = $emails;

        return $this;
    }

    public function subject($subject='')
    {
        $this->subject = $subject;

        return $this;
    }

    public function message($message='')
    {
        $this->message = $message;

        return $this;
    }

    public function send()
    {
        $mail = new PHPMailer(true);

        try {
            //Server settings
            $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      // Enable verbose debug output
            $mail->isSMTP();                                            // Send using SMTP
            $mail->Host       = $_SERVER['SERVER_NAME'];                    // Set the SMTP server to send through
            $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
            $mail->Username   = 'no-reply@e-visa.ke';                     // SMTP username
            $mail->Password   = 'Kd{vP{8ZjW5N';                               // SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;         // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` encouraged
            $mail->Port       = 587;                                    // TCP port to connect to, use 465 for `PHPMailer::ENCRYPTION_SMTPS` above

            //Recipients
            $mail->setFrom('no-reply@e-visa.ke', 'e-Visa');
            $mail->addAddress($this->to);     // Add a recipient
            //$mail->addAddress('ellen@example.com');               // Name is optional
            //$mail->addReplyTo('info@example.com', 'Information');
            //$mail->addCC('cc@example.com');
            //$mail->addBCC('bcc@example.com');

            // Attachments
            //$mail->addAttachment('/var/tmp/file.tar.gz');         // Add attachments
            //$mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name

            // Content
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->Subject = $this->subject;
            $mail->Body    = $this->message;
            //$mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

            $mail->send();

            return json_encode([
                'status' => 200,
                'message' => 'message sent successfully'
            ]);
        } catch (Exception $e) {
            return json_encode([
                'status' => 400,
                'message' => $mail->ErrorInfo
            ]);

        }
    }

}