<?php

namespace Ipay\EmailClient;

class MailClient
{
    public $to;
    public $from;
    public $cc;
    public $subject;
    public $message;

    public function __construct()
    {
    }

    public function to($to='')
    {
        $this->to = $to;

        return $this;
    }

    public function from($from='')
    {
        $this->from = $from;

        return $this;
    }

    public function cc(array $cc = [])
    {
        if (empty($cc)){
            return null;
        }

        $emails = implode(" ", $cc);
        $this->cc = $emails;

        return $this;
    }

    public function subject($subject='')
    {
        $this->subject = $subject;

        return $this;
    }

    public function message($message='')
    {
        $this->message = $message;

        return $this;
    }

    public function send()
    {
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: <$this->from>" . "\r\n";
        if (!empty($this->cc)){
            $headers .= "Cc:" .implode(",", $this->cc). "\r\n";
        }

        if (mail($this->to, $this->subject, $this->message, $headers)){
            return json_encode([
                'status' => 200,
                'message' => 'message sent successfully'
            ]);
        }
        return json_encode([
            'status' => 400,
            'message' => "main not sent"
        ]);
    }
}